# BOG Payment Gateway - Installation & Testing Guide

## Quick Start Guide

### Step 1: Installation

1. **Upload to WordPress**
   ```bash
   # Via FTP/SFTP
   Upload the entire 'bog-payment-gateway' folder to:
   /wp-content/plugins/
   ```

2. **Activate Plugin**
   - Go to WordPress Admin → Plugins
   - Find "BOG Payment Gateway"
   - Click "Activate"

### Step 2: Get API Credentials

1. **Register with BOG**
   - Go to https://bonline.bog.ge
   - Register your business as a merchant
   - Complete KYC verification

2. **Get API Access**
   - Login to https://bonline.bog.ge/admin/api
   - Create new application
   - Note down your `client_id` and `client_secret`

3. **Configure Callback URL**
   - Your callback URL will be:
     ```
     https://yoursite.com/?wc-api=bog_payment_callback
     ```
   - Provide this to BOG support team

### Step 3: Configure Plugin

1. **Go to Payment Settings**
   - WooCommerce → Settings → Payments
   - Click "BOG Payment Gateway"

2. **Enter Settings**
   ```
   ✓ Enable BOG Payment Gateway
   Title: Credit Card (BOG)
   Description: Pay securely with your credit card
   
   Test Mode: ✓ Enabled (for testing)
   Test Client ID: [your test client_id]
   Test Client Secret: [your test client_secret]
   
   Client ID: [your production client_id]
   Client Secret: [your production client_secret]
   ```

3. **Save Changes**

### Step 4: Test Payment

1. **Create Test Order**
   - Add products to cart
   - Go to checkout
   - Select "Credit Card (BOG)" as payment method
   - Fill in billing details
   - Click "Place Order"

2. **Payment Flow**
   - You'll be redirected to BOG payment page
   - Enter test card details (provided by BOG)
   - Complete payment

3. **Verify**
   - You'll be redirected back to success page
   - Check order status in WooCommerce → Orders
   - Should show "Processing" or "Completed"

4. **Check Logs**
   - Go to WooCommerce → BOG Payments
   - View transaction logs
   - Verify all API calls succeeded

## Testing Scenarios

### 1. Successful Payment

**Steps:**
1. Create order with valid card
2. Complete payment on BOG page
3. Verify order status changes to "Processing"
4. Check callback received in logs

**Expected:**
- Order status: Processing/Completed
- Transaction ID saved
- Order note added
- Email sent to customer

### 2. Failed Payment

**Steps:**
1. Create order
2. Use invalid card or cancel payment
3. Return to shop

**Expected:**
- Order status: Pending/Failed
- Error message displayed
- Callback shows rejection reason
- Customer can retry

### 3. Refund (Full)

**Steps:**
1. Process successful order
2. Go to order in admin
3. Click "Refund"
4. Enter reason
5. Click "Refund via BOG Payment Gateway"

**Expected:**
- Refund processed via API
- Order status: Refunded
- Order note added
- Money returned to customer

### 4. Refund (Partial)

**Steps:**
1. Process successful order
2. Go to order in admin
3. Click "Refund"
4. Enter partial amount
5. Enter reason
6. Click "Refund via BOG Payment Gateway"

**Expected:**
- Partial amount refunded
- Order status: Partially Refunded
- Order note shows refunded amount
- Remaining balance intact

## Test Card Numbers

Contact BOG support for test card numbers. Typically:

**Successful Payment:**
- Card: [Contact BOG for test cards]
- CVV: Any 3 digits
- Expiry: Any future date

**Failed Payment:**
- Card: [Contact BOG for failure test cards]

## Common Issues & Solutions

### Issue 1: "Authentication Failed"

**Cause:** Wrong credentials or expired token

**Solution:**
1. Verify client_id and client_secret are correct
2. Check you're using test credentials in test mode
3. Check credentials haven't expired
4. Contact BOG support to verify account status

### Issue 2: "Callback Not Received"

**Cause:** Callback URL not configured or blocked

**Solution:**
1. Verify callback URL with BOG support
2. Check server isn't blocking external POST requests
3. Temporarily disable security plugins
4. Check `.htaccess` rules
5. Verify WooCommerce API is enabled

### Issue 3: "Order Not Found"

**Cause:** Order ID mismatch or deleted order

**Solution:**
1. Check order exists in WooCommerce
2. Verify order hasn't been trashed
3. Check callback data in logs
4. Ensure external_order_id matches WC order ID

### Issue 4: "Refund Failed"

**Cause:** Missing BOG order ID or payment not completed

**Solution:**
1. Verify order has `_bog_order_id` meta
2. Check payment was actually completed
3. Verify refund amount is valid
4. Check API credentials have refund permissions
5. Review error in transaction logs

## Development & Debugging

### Enable Debug Mode

Add to `wp-config.php`:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

### Check Error Logs

```bash
# WordPress debug log
/wp-content/debug.log

# Server error log
/var/log/apache2/error.log  # Apache
/var/log/nginx/error.log    # Nginx
```

### View Transaction Logs

1. Go to WooCommerce → BOG Payments
2. Filter by status: Error
3. Click "View Details" to see full request/response
4. Look for error messages in response data

### Test Callback Manually

```bash
# Send test callback
curl -X POST 'https://yoursite.com/?wc-api=bog_payment_callback' \
  -H 'Content-Type: application/json' \
  -d '{
    "order_id": "bog-order-id",
    "external_order_id": "123",
    "order_status": {
      "key": "completed",
      "value": "დასრულებული"
    },
    "purchase_units": {
      "transfer_amount": "100.00",
      "currency_code": "GEL"
    },
    "payment_method": "card"
  }'
```

## API Endpoints Reference

### Authentication
```
POST https://oauth2.bog.ge/auth/realms/bog/protocol/openid-connect/token
```

**Request:**
```
grant_type=client_credentials
client_id=YOUR_CLIENT_ID
client_secret=YOUR_CLIENT_SECRET
```

### Create Order
```
POST https://api.bog.ge/payments/v1/ecommerce/orders
```

**Headers:**
```
Authorization: Bearer {token}
Content-Type: application/json
Accept-Language: ka
```

**Body:**
```json
{
  "callback_url": "https://yoursite.com/?wc-api=bog_payment_callback",
  "external_order_id": "123",
  "purchase_units": {
    "currency": "GEL",
    "total_amount": 100.50,
    "basket": [
      {
        "product_id": "1",
        "description": "Product Name",
        "quantity": 1,
        "unit_price": 100.50,
        "total_price": 100.50
      }
    ]
  },
  "redirect_urls": {
    "success": "https://yoursite.com/checkout/order-received/",
    "fail": "https://yoursite.com/checkout/"
  },
  "buyer": {
    "full_name": "John Doe",
    "email": "john@example.com",
    "phone": "+995555000000"
  }
}
```

### Get Payment Details
```
GET https://api.bog.ge/payments/v1/payment/status/{order_id}
```

### Refund
```
POST https://api.bog.ge/payments/v1/payment/refund/{order_id}
```

**Body (optional for partial refund):**
```json
{
  "amount": "50.00"
}
```

## Production Checklist

Before going live:

- [ ] SSL certificate installed (HTTPS enabled)
- [ ] Production API credentials configured
- [ ] Test mode disabled
- [ ] Callback URL verified with BOG
- [ ] Test successful payment flow
- [ ] Test failed payment flow
- [ ] Test refund functionality
- [ ] Email notifications working
- [ ] Transaction logging enabled
- [ ] Error handling tested
- [ ] Customer support contact ready
- [ ] Terms of service updated
- [ ] Privacy policy updated
- [ ] Staff trained on refund process
- [ ] Backup system in place

## Support Contacts

**Plugin Support:**
- Email: support@workflowdone.com
- Website: https://workflowdone.com

**BOG Support:**
- Contact Bank of Georgia support team
- Technical documentation: https://api.bog.ge/docs/en/payments/introduction

## Additional Resources

- [BOG API Documentation](https://api.bog.ge/docs/en/payments/introduction)
- [WooCommerce Documentation](https://woocommerce.com/documentation/)
- [WordPress Codex](https://codex.wordpress.org/)
