# BOG Payment Gateway for WordPress/WooCommerce

Bank of Georgia credit card payment gateway plugin for WordPress and WooCommerce.

## Features

- ✅ **Credit Card Payments** - Accept VISA, Mastercard, and American Express
- ✅ **Order Creation** - Automatically create payment orders via BOG API
- ✅ **Secure Redirect** - Redirect customers to secure BOG payment page
- ✅ **Callback Handling** - Automatic payment status updates via webhook
- ✅ **Payment Details** - Retrieve complete payment information
- ✅ **Refunds** - Process full or partial refunds directly from WooCommerce
- ✅ **Transaction Logs** - Complete logging system for debugging
- ✅ **Test Mode** - Separate test/production credentials
- ✅ **OAuth 2.0** - Secure authentication with JWT tokens
- ✅ **Multiple Payment Methods** - Supports card, Google Pay, Apple Pay (if enabled by BOG)

## Requirements

- WordPress 5.8 or higher
- WooCommerce 5.0 or higher
- PHP 7.4 or higher
- SSL certificate (HTTPS required)
- BOG Merchant Account with API credentials

## Installation

1. **Upload Plugin**
   - Upload the `bog-payment-gateway` folder to `/wp-content/plugins/`
   - Or install via WordPress admin: Plugins → Add New → Upload Plugin

2. **Activate Plugin**
   - Go to Plugins → Installed Plugins
   - Activate "BOG Payment Gateway"

3. **Configure Settings**
   - Go to WooCommerce → Settings → Payments
   - Click on "BOG Payment Gateway"
   - Enable the payment method
   - Enter your API credentials (Client ID and Client Secret)

## Configuration

### Getting API Credentials

1. Register as a merchant at [bonline.bog.ge](https://bonline.bog.ge)
2. Navigate to API settings at https://bonline.bog.ge/admin/api
3. Register your application
4. Copy your Client ID and Client Secret
5. Provide your callback URL to BOG support

### Plugin Settings

**WooCommerce → Settings → Payments → BOG Payment Gateway**

- **Enable/Disable** - Enable the payment gateway
- **Title** - Payment method title shown to customers
- **Description** - Payment method description
- **Test Mode** - Enable to use test credentials
- **Client ID (Production)** - Your production API Client ID
- **Client Secret (Production)** - Your production API Client Secret
- **Test Client ID** - Your test API Client ID
- **Test Client Secret** - Your test API Client Secret

### Callback URL

Your callback URL is automatically generated:
```
https://yourdomain.com/?wc-api=bog_payment_callback
```

Provide this URL to BOG support team.

## How It Works

### Payment Flow

1. **Customer Checkout** - Customer proceeds to checkout and selects BOG payment method
2. **Order Creation** - Plugin creates order via BOG API
3. **Redirect** - Customer is redirected to secure BOG payment page
4. **Payment** - Customer enters card details and completes payment
5. **Callback** - BOG sends payment status to your callback URL
6. **Confirmation** - Order status is updated automatically

### Order Statuses

- **Created** - Payment initiated, awaiting completion
- **Completed** - Payment successful, order processing
- **Blocked** - Pre-authorization completed, awaiting confirmation
- **Partial Completed** - Partial payment received
- **Rejected** - Payment failed or declined
- **Refunded** - Payment refunded
- **Expired** - Payment session expired

## Features

### 1. Order Request

Automatically creates payment orders with:
- Order details and items
- Customer information
- Amount and currency
- Callback and redirect URLs

### 2. Callback Processing

Handles payment notifications:
- Automatic order status updates
- Transaction ID recording
- Payment method tracking
- Error handling

### 3. Payment Details

Retrieve complete payment information:
- Transaction status
- Payment method used
- Amount details
- Customer information

### 4. Refunds

Process refunds directly from WooCommerce:
- Full refunds
- Partial refunds
- Automatic order notes
- Transaction logging

### 5. Transaction Logs

Complete logging system:
- View all transactions
- Filter by status, type, order
- Export/import capabilities
- Detailed request/response data

## Admin Interface

### Transaction Logs

**WooCommerce → BOG Payments**

View and manage all transactions:
- Real-time statistics
- Filter by status, type, date
- View detailed request/response data
- Export logs for accounting
- Clear old logs

### Statistics Dashboard

- Total transactions
- Successful payments
- Failed payments
- Today's transactions

## API Endpoints

### Base URL
- Production: `https://api.bog.ge/payments/v1`
- Test: `https://api.bog.ge/payments/v1`

### Authentication
- OAuth 2.0 with Client Credentials
- JWT tokens (auto-managed by plugin)

### Endpoints Used

1. **Create Order**: `POST /ecommerce/orders`
2. **Get Payment Details**: `GET /payment/status/{order_id}`
3. **Refund**: `POST /payment/refund/{order_id}`

## Database Tables

### bog_payment_logs

Stores all transaction logs:
- `id` - Log entry ID
- `order_id` - BOG order ID
- `wc_order_id` - WooCommerce order ID
- `transaction_type` - Type of transaction
- `request_data` - Request payload
- `response_data` - API response
- `status` - Transaction status
- `created_at` - Timestamp

## Security

- ✅ HTTPS required for all API calls
- ✅ OAuth 2.0 authentication
- ✅ JWT tokens with automatic refresh
- ✅ Secure credential storage
- ✅ Callback URL verification
- ✅ Input sanitization
- ✅ SQL injection prevention
- ✅ XSS protection

## Troubleshooting

### Payment Not Processing

1. Check API credentials are correct
2. Verify test/production mode matches credentials
3. Check error logs in BOG Payments admin page
4. Ensure HTTPS is enabled
5. Verify callback URL with BOG support

### Callback Not Working

1. Verify callback URL is whitelisted with BOG
2. Check server can receive external requests
3. Disable security plugins temporarily
4. Check WooCommerce API logs
5. Test with BOG support team

### Refund Failed

1. Ensure order has BOG order ID
2. Check payment was completed successfully
3. Verify refund amount doesn't exceed paid amount
4. Check API credentials have refund permissions
5. Review error in transaction logs

## Support

- **Documentation**: https://api.bog.ge/docs/en/payments/introduction
- **Plugin Support**: support@function.ge
- **BOG Support**: Contact Bank of Georgia support team

## Changelog

### 1.0.0 - 2024-11-30
- Initial release
- Credit card payment support
- Order creation and processing
- Callback handling
- Payment details retrieval
- Refund functionality
- Transaction logging
- Admin interface
- Test/Production mode

## License

GPL v2 or later

## Credits

Developed by [function.ge](https://function.ge)

## Frequently Asked Questions

**Q: Do I need a BOG merchant account?**
A: Yes, you need to be registered as a merchant with Bank of Georgia and have API credentials.

**Q: What currencies are supported?**
A: The plugin supports the currency configured in your WooCommerce settings. BOG typically supports GEL.

**Q: Can I test before going live?**
A: Yes, enable Test Mode in settings and use your test API credentials.

**Q: Are there transaction fees?**
A: Contact Bank of Georgia for information about transaction fees and merchant rates.

**Q: Can customers save cards?**
A: Card saving functionality can be added as a feature extension if needed.

**Q: Do you support installments?**
A: This version focuses on direct credit card payments. Installment support can be added separately.
