/* BOG Payment Gateway - Admin JavaScript */

jQuery(document).ready(function($) {
    
    // View details modal
    $('.bog-view-details').on('click', function(e) {
        e.preventDefault();
        
        var logId = $(this).data('log-id');
        var details = $('#bog-details-' + logId).html();
        
        // Create modal
        var modal = $('<div id="bog-details-modal"></div>');
        var overlay = $('<div id="bog-details-overlay"></div>');
        var closeBtn = $('<button class="bog-close-modal">&times;</button>');
        
        modal.html(details);
        modal.prepend(closeBtn);
        
        $('body').append(overlay).append(modal);
        
        // Close on overlay click
        overlay.on('click', function() {
            closeModal();
        });
        
        // Close on button click
        closeBtn.on('click', function() {
            closeModal();
        });
        
        // Close on ESC key
        $(document).on('keyup.bogModal', function(e) {
            if (e.keyCode === 27) {
                closeModal();
            }
        });
        
        function closeModal() {
            modal.remove();
            overlay.remove();
            $(document).off('keyup.bogModal');
        }
    });
    
    // Format JSON in pre tags
    $('#bog-details-modal pre').each(function() {
        try {
            var json = JSON.parse($(this).text());
            $(this).text(JSON.stringify(json, null, 2));
        } catch(e) {
            // Not valid JSON, leave as is
        }
    });
});
