<?php
/**
 * Uninstall script for BOG Payment Gateway
 * 
 * This file is executed when the plugin is deleted via WordPress admin
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Delete options
delete_option('woocommerce_bog_payment_settings');

// Delete order meta
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_bog_%'");

// Option to keep or delete logs
$bog_payment_keep_logs = get_option('bog_payment_keep_logs_on_uninstall', false);

if (!$bog_payment_keep_logs) {
    // Drop logs table
    $bog_payment_table_name = $wpdb->prefix . 'bog_payment_logs';
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $wpdb->query("DROP TABLE IF EXISTS `{$bog_payment_table_name}`");
}

// Clear any cached data
wp_cache_flush();
